/*

Combustion Output MacroScript File
Created:		Sept 6 2000
Author:		Fred Moreau

Revision History:
	Yann Bertaud
		changed the method for which the render element filename was retrieved. Using the new GetRenderElementFilename method. 
		re.bitmap.filename was replaced by refilename which is defined by eman.GetRenderElementfilename (e)
		
	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
	

*/

Macroscript CombustionOutput 
category:~COMBUSTIONOUTPUT_CATEGORY~ 
internalCategory:"File"
ButtonText:~COMBUSTIONOUTPUT_BUTTONTEXT~
tooltip:~COMBUSTIONOUTPUT_TOOLTIP~
icon:#("CWS_Output",2)
silentErrors:true
(
	SetSilentMode true											-- Set Silent Mode for BitMap Loading
	eman = maxOps.GetCurRenderElementMgr()						-- Get Current Render Elements Manager
	if (eman.NumRenderElements()) > 0 and (eman.GetElementsActive()) == true and eman.GetCombustionOutputPath() != "" then
	(
		try
		(
			re_array = #()										-- Init the RenderElements Array
			for e = 0 to (eman.NumRenderElements() - 1) do		-- For all RenderElements in REManager
			(
				re = eman.GetRenderElement e					-- Get the Element
				refilename = eman.GetRenderElementfilename (e)	-- added for 3ds max 5, use new GetRenderElementFilename method to get render element filename.
				try (re.enabled ; OkToGo = True) catch (OkToGo = False) -- Is Element Plug-In Missing
				if OkToGo then							-- If Element is not Standin
				(
					if re.enabled == true and refilename != undefined then	-- If Element Enabled
					(
						if not IsCwsImgType refilename then	-- Check combustion ImageType Compliance
						(
							Print ~OK~
							cwsMessage = ~CWSMESSAGE_WARNING_IMAGE_TYPE_NOT_SUPPORTED_IN_COMBUSTION~ +
							(re.elementName + ~ELEMENT_IS_OUTPUTTING_TO~ + (getfilenameType refilename) + ~FILES~)
							cwsWarn cwsMessage
						)
						else
						(
							if ((KindOfRenderElement re) == #Diffuse or (KindOfRenderElement re) == #Shadow or (KindOfRenderElement re) == #Atmosphere) and (findItem #(".tga", ".tif", ".rla", ".rpf", ".png") (getfilenameType refilename) == 0) then
							(
								cwsMessage = ~CWSMESSAGE_WARNING_ELEMENT_REQUIRES_ALPHA~ +
								re.elementName + ~ELEMENT_NAME_ELEMENT_IS_OUTPUTTING_TO~ + (getfilenameType refilename) + ~ELEMENT_NAME_FILES~ +
								~IT_IS_RECOMMENDED_TO_OUTPUT_DIFFUSE_SHADOWS_AND_ATMOSPHERE_ELEMENTS~
								cwsWarn cwsMessage
							)
							cwselement = relement name:re.elementName kind:(KindOfRenderElement re) file:refilename transferMode:1 Visibility:Off
							append re_array cwselement				-- Add RenderElement to the Process List
						)
					)-- end If Enabled
					else
					(
						cwsMessage = ~WARNING~ + re.elementName + ~ELEMENT_HAS_NO_BITMAP_OR_IS_DISABLED~
						cwsWarn cwsMessage
					)
				)-- end If not Standin
				else
				(
					cwsMessage = ~CWSMESSAGE_WARNING_ELEMENT_IS_USING_MISSING_DLL~
					cwsWarn cwsMessage
				)
			)-- end for loop
			if re_array.count != 0 then
			(
				RElements2cws re_array (eman.GetCombustionOutputPath())
				print ~PRINT_RENDER_ELEMENTS_HAVE_BEEN_OUTPUTTED_TO_COMBUSTION_SUCCESSFULLY~
			)-- end if
			Else
			(
				cwsMessage = ~CWSMESSAGE_NO_RENDER_ELEMENTS_TO_OUTPUT~
				cwsWarn cwsMessage
			)
		)-- end try
		catch
		(
			try (close (eman.GetCombustionOutputPath())) catch()
			cwsMessage = ~CWSMESSAGE_ERRORS_OCCURED_WHEN_OUTPUTTING_TO_COMBUSTION_FILE~
			cwsWarn cwsMessage
		)-- end catch
	)
	else
	(
			cwsMessage = ~WARNING_COMBUSTION_WORKSPACE_FILE_NOT_SET~ +
~OR_NO_RENDER_ELEMENTS_TO_OUTPUT~
			cwsWarn cwsMessage
	)
	SetSilentMode false -- Reset Silent Mode Off for BitMap Loading
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBe1FKs+U7H6x0+XjsmsKTDxUiQV0wvhHzl
-- tbfKfbf85YX+JKHpxKDHnuT+/O04p7d6/X7cu2LsYElms1ydU8VCbiERCMhNWPU4
-- +vgyglAdHEyuwRNXYC17G0Ceo51waE/KZD5B5HNGyUG32pm5H8u2E5qF7KR4Qkpz
-- UCWsYB0RfCwJmS96W+33dCxDAOzRoG1EAWHVNNpUCWXHeNKgW/mfPE4Q4kbSQsKQ
-- KuXcFZbdrsrSde1PQ/e7h7YsvCrr8nUXj03tVBk0uQVB+Eb30CKxN5SJFmDLL412
-- /PFvUmu/liytJsPL9+8lX7zO9AN10nJNBlUbtmANZcXJv6d2vE1/
-- -----END-SIGNATURE-----